import kotlinx.browser.document
import kotlinx.browser.window
import org.w3c.dom.HTMLDivElement
import org.w3c.dom.HTMLElement
import xim.poc.MainTool
import xim.poc.browser.BrowserPlatformDependencies
import xim.poc.browser.DomainSpecificConfigs
import xim.poc.browser.PlatformDependencies
import xim.poc.game.GameState
import xim.poc.game.configuration.GameLogic
import xim.poc.tools.DebugToolsManager
import xim.util.OnceLogger

private var started = false
private lateinit var platform: PlatformDependencies

private lateinit var gameMode: GameLogic

fun main() {
    gameMode = DomainSpecificConfigs.apply()

    if (isLocalHost()) {
        onStart(gameMode)
    } else {
        val startButton = (document.getElementById("start-container") as HTMLElement)
        startButton.onclick = { onStart(gameMode) }
    }
}

private fun onStart(gameMode: GameLogic) {
    if (started) { return }
    started = true

    val startContainer = document.getElementById("start-container") as HTMLDivElement
    startContainer.remove()

    platform = BrowserPlatformDependencies.get(canvasId = "canvas") ?: return

    GameState.setGameMode(gameMode)
    if (isLocalHost() || gameMode.configuration.debugControlsEnabled) {
        OnceLogger.enabled = true
        DebugToolsManager.debugEnabled = true
        DebugToolsManager.showDebugOnlyTools()
    }

    if (isLocalHost()) {
        DebugToolsManager.showLocalHostTools()
    }

    MainTool.run(platform)
}

fun isLocalHost(): Boolean {
    return window.location.hostname == "localhost"
}