package xim.poc.browser

import kotlinx.browser.document
import kotlinx.browser.window
import kotlinx.dom.addClass
import org.w3c.dom.HTMLDetailsElement
import xim.poc.game.configuration.GameLogic
import xim.poc.game.configuration.assetviewer.AssetViewer
import xim.poc.game.configuration.v0.GameV0

object DomainSpecificConfigs {

    fun apply(): GameLogic {
        val hostnameParts = window.location.hostname.split('.')
        if (hostnameParts.any { it == "itch" }) { return applyItch() }
        return applyDefault()
    }

    private fun applyDefault(): GameLogic {
        return toGameLogic(ExecutionEnvironment.getExecutionParameter("mode"))
    }

    private fun applyItch(): GameLogic {
        val appsDetails = (document.getElementById("apps-details") as? HTMLDetailsElement)
        appsDetails?.addClass("debugTool")
        return GameV0
    }

    private fun toGameLogic(id: String?): GameLogic {
        return when (id) {
            "game" -> GameV0
            else -> AssetViewer
        }
    }

}