package xim.poc.browser

import kotlinx.browser.window
import xim.util.Periodically
import kotlin.time.Duration.Companion.minutes

object RemoteMetrics {

    private val publishRateLimiter = Periodically(1.minutes)
    private val metrics = HashMap<String, String>()

    fun append(vararg entries: Pair<String, String>) {
        entries.forEach { metrics[it.first] = it.second }
    }

    fun publish() {
        if (!publishRateLimiter.ready()) { return }
        if (metrics.isEmpty()) { return }

        val query = metrics.entries.joinToString("&") { "${it.key}=${it.value}" }
        metrics.clear()

        val metricsPath = ExecutionEnvironment.getMetricsPath()
        if (metricsPath == null) {
            println("Metrics: $query")
            return
        }

        window.fetch("$metricsPath?$query")
    }

}