package xim.poc.game.configuration.v0.events

import xim.poc.ActorId
import xim.poc.UiElementHelper.formatPrice
import xim.poc.game.ActorStateManager
import xim.poc.game.actor.components.*
import xim.poc.game.configuration.v0.GameV0
import xim.poc.game.event.Event
import xim.poc.game.event.InventoryItemTransferEvent
import xim.poc.ui.ChatLog
import xim.poc.ui.ChatLogColor

class ShopSellEvent(
    val vendorId: ActorId,
    val shopperId: ActorId,
    val selectedItemId: InternalItemId,
    val quantity: Int,
) : Event {

    companion object {
        const val sellPriceDivider = 4
    }

    override fun apply(): List<Event> {
        val vendor = ActorStateManager[vendorId] ?: return emptyList()
        val shopper = ActorStateManager[shopperId] ?: return emptyList()

        val item = shopper.getInventory().getByInternalId(selectedItemId) ?: return emptyList()
        if (quantity > item.quantity || quantity <= 0) { return emptyList() }
        if (shopper.isEquipped(item)) { return emptyList() }

        val itemPrice = GameV0.getItemPrice(vendorId, item) ?: return emptyList()
        val sellCurrencyAmount = quantity * itemPrice.second / sellPriceDivider
        shopper.adjustCurrency(itemPrice.first, sellCurrencyAmount)

        if (shopper.isPlayer()) {
            ChatLog.addLine("Sold ${ChatLog.getItemString(item, quantity)} for ${formatPrice(itemPrice.first, sellCurrencyAmount)}", ChatLogColor.Info)
        }

        return listOf(InventoryItemTransferEvent(
            sourceId = shopperId,
            destinationId = vendorId,
            inventoryItemId = selectedItemId,
            quantity = quantity,
            actionContext = null,
        ))
    }

}