package xim.poc.game.configuration.v0.interactions

import xim.poc.ActorId
import xim.poc.game.QueryMenuOption
import xim.poc.game.QueryMenuResponse
import xim.poc.game.UiStateHelper
import xim.poc.game.configuration.v0.GameTower
import xim.poc.game.configuration.v0.GameV0Helpers
import xim.poc.game.configuration.v0.GameV0SaveStateHelper
import xim.poc.game.configuration.v0.constants.*

private class MusicOption(val musicId: Int, val displayName: String, val unlockCondition: () -> Boolean = { false })

object MusicInteraction : NpcInteraction {

    private val options = listOf(
        MusicOption(displayName = "Devils' Delight", musicId = 28),
        MusicOption(displayName = "Sojourner", musicId = 30),
        MusicOption(displayName = "Goddesspeed", musicId = 35),
        MusicOption(displayName = "Good Fortune", musicId = 36),
        MusicOption(displayName = "Cloister of Time and Souls", musicId = 40),
        MusicOption(displayName = "Royal Wanderlust", musicId = 41),
        MusicOption(displayName = "Snowdrift Waltz", musicId = 42) { GameTower.hasClearedFloor(46) },
        MusicOption(displayName = "Troubled Shadows", musicId = 43) { GameV0Helpers.hasDefeated(mobZirnitra_120) },
        MusicOption(displayName = "Where Lords Rule Not", musicId = 44),
        MusicOption(displayName = "Summers Lost", musicId = 45),
        MusicOption(displayName = "Goddess Divine", musicId = 46),
        MusicOption(displayName = "Echoes of Creation", musicId = 47) { GameTower.hasClearedFloor(40) },
        MusicOption(displayName = "Main Theme -FINAL FANTASY XI Version", musicId = 48),
        MusicOption(displayName = "Luck of the Mog", musicId = 49),
        MusicOption(displayName = "Feast of the Ladies", musicId = 50),
        MusicOption(displayName = "Abyssea - Scarlet Skies, Shadowed Plains", musicId = 51) { GameV0Helpers.hasDefeated(mobHadhayosh_135_021) },
        MusicOption(displayName = "Melodies Errant", musicId = 52),
        MusicOption(displayName = "Shinryu", musicId = 53),
        MusicOption(displayName = "Everlasting Bonds", musicId = 54),
        MusicOption(displayName = "Provenance Watcher", musicId = 55),
        MusicOption(displayName = "Where it All Begins", musicId = 56),
        MusicOption(displayName = "Steel Sings, Blades Dance", musicId = 57),
        MusicOption(displayName = "A New Direction", musicId = 58),
        MusicOption(displayName = "The Pioneers", musicId = 59),
        MusicOption(displayName = "Into Lands Primeval - Ulbuka", musicId = 60) { GameTower.hasClearedFloor(9) },
        MusicOption(displayName = "Water's Umbral Knell", musicId = 61) { GameTower.hasClearedFloor(45) },
        MusicOption(displayName = "Keepers of the Wild", musicId = 62) { GameTower.hasClearedFloor(10) },
        MusicOption(displayName = "The Sacred City of Adoulin", musicId = 63) { true },
        MusicOption(displayName = "Breaking Ground", musicId = 64),
        MusicOption(displayName = "Hades", musicId = 65),
        MusicOption(displayName = "Arciela", musicId = 66),
        MusicOption(displayName = "Mog Resort", musicId = 67),
        MusicOption(displayName = "Worlds Away", musicId = 68),
        MusicOption(displayName = "Monstrosity", musicId = 70),
        MusicOption(displayName = "The Serpentine Labyrinth", musicId = 72),
        MusicOption(displayName = "The Divine", musicId = 73),
        MusicOption(displayName = "Clouds Over Ulbuka", musicId = 74),
        MusicOption(displayName = "The Price", musicId = 75),
        MusicOption(displayName = "Forever Today", musicId = 76),
        MusicOption(displayName = "Forever Today (instrumental version)", musicId = 78),
        MusicOption(displayName = "Iroha", musicId = 79),
        MusicOption(displayName = "The Boundless Black", musicId = 80) { GameV0Helpers.hasDefeated(mobAziDahaka_288_050) },
        MusicOption(displayName = "Isle of the Gods", musicId = 81),
        MusicOption(displayName = "Wail of the Void", musicId = 82),
        MusicOption(displayName = "Rhapsodies of Vana'diel", musicId = 83),
        MusicOption(displayName = "Full Speed Ahead!", musicId = 84),
        MusicOption(displayName = "Times Grow Tense", musicId = 85),
        MusicOption(displayName = "For a Friend", musicId = 87),
        MusicOption(displayName = "Between Dreams and Reality", musicId = 88),
        MusicOption(displayName = "Disjoined One", musicId = 89),
        MusicOption(displayName = "Winds of Change", musicId = 90),
        MusicOption(displayName = "Battle Theme", musicId = 101),
        MusicOption(displayName = "Battle in the Dungeon #2", musicId = 102),
        MusicOption(displayName = "Battle Theme #2", musicId = 103),
        MusicOption(displayName = "A Road Once Traveled", musicId = 104),
        MusicOption(displayName = "Mhaura", musicId = 105),
        MusicOption(displayName = "Voyager", musicId = 106),
        MusicOption(displayName = "The Kingdom of San d'Oria", musicId = 107),
        MusicOption(displayName = "Vana'diel March", musicId = 108),
        MusicOption(displayName = "Ronfaure", musicId = 109),
        MusicOption(displayName = "The Grand Duchy of Jeuno", musicId = 110),
        MusicOption(displayName = "Blackout", musicId = 111),
        MusicOption(displayName = "Selbina", musicId = 112),
        MusicOption(displayName = "Sarutabaruta", musicId = 113),
        MusicOption(displayName = "Batallia Downs", musicId = 114),
        MusicOption(displayName = "Battle in the Dungeon", musicId = 115),
        MusicOption(displayName = "Gustaberg", musicId = 116),
        MusicOption(displayName = "Ru'Lude Gardens", musicId = 117),
        MusicOption(displayName = "Rolanberry Fields", musicId = 118),
        MusicOption(displayName = "Awakening", musicId = 119) { GameV0Helpers.hasDefeated(mobShadowLord_103) },
        MusicOption(displayName = "Vana'diel March #2", musicId = 120),
        MusicOption(displayName = "Shadow Lord", musicId = 121),
        MusicOption(displayName = "One Last Time", musicId = 122),
        MusicOption(displayName = "Hopelessness", musicId = 123),
        MusicOption(displayName = "Recollection", musicId = 124),
        MusicOption(displayName = "Tough Battle", musicId = 125),
        MusicOption(displayName = "Mog House", musicId = 126) { true },
        MusicOption(displayName = "Anxiety", musicId = 127),
        MusicOption(displayName = "Airship", musicId = 128),
        MusicOption(displayName = "Hook, Line, and Sinker", musicId = 129),
        MusicOption(displayName = "Tarutaru Female", musicId = 130),
        MusicOption(displayName = "Elvaan Female", musicId = 131),
        MusicOption(displayName = "Elvaan Male", musicId = 132),
        MusicOption(displayName = "Hume Male", musicId = 133),
        MusicOption(displayName = "Yuhtunga Jungle", musicId = 134),
        MusicOption(displayName = "Kazham", musicId = 135),
        MusicOption(displayName = "The Big One", musicId = 136),
        MusicOption(displayName = "A Realm of Emptiness", musicId = 137),
        MusicOption(displayName = "Mercenaries' Delight", musicId = 138),
        MusicOption(displayName = "Delve", musicId = 139),
        MusicOption(displayName = "Wings of the Goddess", musicId = 140),
        MusicOption(displayName = "The Cosmic Wheel", musicId = 141),
        MusicOption(displayName = "Fated Strife -Besieged-", musicId = 142),
        MusicOption(displayName = "Hellriders", musicId = 143),
        MusicOption(displayName = "Rapid Onslaught -Assault-", musicId = 144),
        MusicOption(displayName = "Encampment Dreams", musicId = 145),
        MusicOption(displayName = "The Colosseum", musicId = 146),
        MusicOption(displayName = "Eastward Bound...", musicId = 147),
        MusicOption(displayName = "Forbidden Seal", musicId = 148),
        MusicOption(displayName = "Jeweled Boughs", musicId = 149) { GameTower.hasClearedFloor(35) },
        MusicOption(displayName = "Ululations from Beyond", musicId = 150),
        MusicOption(displayName = "The Federation of Windurst", musicId = 151),
        MusicOption(displayName = "The Republic of Bastok", musicId = 152),
        MusicOption(displayName = "Prelude", musicId = 153),
        MusicOption(displayName = "Metalworks", musicId = 154),
        MusicOption(displayName = "Castle Zvahl", musicId = 155),
        MusicOption(displayName = "Chateau d'Oraguille", musicId = 156),
        MusicOption(displayName = "Fury", musicId = 157),
        MusicOption(displayName = "Sauromugue Champaign", musicId = 158),
        MusicOption(displayName = "Sorrow", musicId = 159),
        MusicOption(displayName = "Repression (Memoro de la S^tono)", musicId = 160),
        MusicOption(displayName = "Despair (Memoro de la S^tono)", musicId = 161),
        MusicOption(displayName = "Heavens Tower", musicId = 162),
        MusicOption(displayName = "Sometime, Somewhere", musicId = 163),
        MusicOption(displayName = "Xarcabard", musicId = 164),
        MusicOption(displayName = "Galka", musicId = 165),
        MusicOption(displayName = "Mithra", musicId = 166),
        MusicOption(displayName = "Tarutaru Male", musicId = 167),
        MusicOption(displayName = "Hume Female", musicId = 168),
        MusicOption(displayName = "Regeneracy", musicId = 169),
        MusicOption(displayName = "Buccaneers", musicId = 170),
        MusicOption(displayName = "Altepa Desert", musicId = 171),
        MusicOption(displayName = "Black Coffin", musicId = 172),
        MusicOption(displayName = "Illusions in the Mist", musicId = 173),
        MusicOption(displayName = "Whispers of the Gods", musicId = 174),
        MusicOption(displayName = "Bandits' Market", musicId = 175),
        MusicOption(displayName = "Circuit de Chocobo", musicId = 176),
        MusicOption(displayName = "Run Chocobo Run!", musicId = 177),
        MusicOption(displayName = "The Bustle of the Capital", musicId = 178),
        MusicOption(displayName = "Vana'diel March #4", musicId = 179),
        MusicOption(displayName = "Thunder of the March", musicId = 180),
        MusicOption(displayName = "Stargazing", musicId = 182),
        MusicOption(displayName = "A Puppet's Slumber", musicId = 183),
        MusicOption(displayName = "Eternal Gravestone", musicId = 184),
        MusicOption(displayName = "Ever-Turning Wheels", musicId = 185),
        MusicOption(displayName = "Iron Colossus", musicId = 186),
        MusicOption(displayName = "Ragnarok", musicId = 187),
        MusicOption(displayName = "Choc-A-Bye-Baby", musicId = 188) { GameTower.hasClearedFloor(35) },
        MusicOption(displayName = "An Invisible Crown", musicId = 189),
        MusicOption(displayName = "The Sanctuary of Zi'Tah", musicId = 190),
        MusicOption(displayName = "Battle Theme #3", musicId = 191),
        MusicOption(displayName = "Battle In the Dungeon #3", musicId = 192),
        MusicOption(displayName = "Tough Battle #2", musicId = 193),
        MusicOption(displayName = "Bloody Promises", musicId = 194),
        MusicOption(displayName = "Belief", musicId = 195),
        MusicOption(displayName = "Fighters of the Crystal", musicId = 196),
        MusicOption(displayName = "To The Heavens", musicId = 197),
        MusicOption(displayName = "Eald'narche", musicId = 198),
        MusicOption(displayName = "Grav'iton", musicId = 199),
        MusicOption(displayName = "Hidden Truths", musicId = 200),
        MusicOption(displayName = "End Theme", musicId = 201),
        MusicOption(displayName = "Moongate", musicId = 202),
        MusicOption(displayName = "Revenant Maiden", musicId = 206),
        MusicOption(displayName = "Ve'Lugannon Palace", musicId = 207),
        MusicOption(displayName = "Rabao", musicId = 208),
        MusicOption(displayName = "Norg", musicId = 209),
        MusicOption(displayName = "Tu'Lia", musicId = 210),
        MusicOption(displayName = "Ro'Maeve", musicId = 211),
        MusicOption(displayName = "Dash de Chocobo", musicId = 212),
        MusicOption(displayName = "Hall of the Gods", musicId = 213),
        MusicOption(displayName = "Eternal Oath", musicId = 214),
        MusicOption(displayName = "Clash of Standards", musicId = 215),
        MusicOption(displayName = "On this Blade", musicId = 216),
        MusicOption(displayName = "Kindred Cry", musicId = 217),
        MusicOption(displayName = "Depths Of The Soul", musicId = 218),
        MusicOption(displayName = "Onslaught", musicId = 219),
        MusicOption(displayName = "Turmoil", musicId = 220),
        MusicOption(displayName = "Moblin Menagerie - Movalpolos", musicId = 221) { GameV0SaveStateHelper.getState().mining.level > 20 },
        MusicOption(displayName = "Faded Memories - Promyvion", musicId = 222) { GameTower.hasClearedFloor(30) },
        MusicOption(displayName = "Conflict: March of the Hero", musicId = 223),
        MusicOption(displayName = "Dusk and Dawn", musicId = 224),
        MusicOption(displayName = "Words Unspoken - Pso'Xja", musicId = 225),
        MusicOption(displayName = "Conflict: You Want To Live Forever?", musicId = 226),
        MusicOption(displayName = "Sunbreeze Shuffle", musicId = 227),
        MusicOption(displayName = "Gates Of Paradise - The Garden of Ru'Hmet", musicId = 228),
        MusicOption(displayName = "The Currents of Time", musicId = 229) { GameTower.hasClearedFloor(12) },
        MusicOption(displayName = "A New Horizon - Tavnazian Archipelago", musicId = 230) { GameTower.hasClearedFloor(5) },
        MusicOption(displayName = "Celestial Thunder", musicId = 231),
        MusicOption(displayName = "Ruler of the Skies", musicId = 232),
        MusicOption(displayName = "The Celestial Capital - Al'Taieu", musicId = 233),
        MusicOption(displayName = "Happily Ever After", musicId = 234),
        MusicOption(displayName = "First Ode: Nocturne Of The Gods", musicId = 235),
        MusicOption(displayName = "Fourth Ode: Clouded Dawn", musicId = 236),
        MusicOption(displayName = "Third Ode: Memoria de la S^tono", musicId = 237),
        MusicOption(displayName = "A New Morning", musicId = 238),
        MusicOption(displayName = "Jeuno ~Starlight Celebration~", musicId = 239),
        MusicOption(displayName = "Second Ode: Distant Promises", musicId = 240),
        MusicOption(displayName = "Fifth Ode: A Time for Prayer", musicId = 241),
        MusicOption(displayName = "Unity", musicId = 242),
        MusicOption(displayName = "The Forgotten City - Tavnazian Safehold", musicId = 245),
        MusicOption(displayName = "March of the Allied Forces", musicId = 246),
        MusicOption(displayName = "Roar of the Battle Drums", musicId = 247),
        MusicOption(displayName = "Young Griffons in Flight", musicId = 248),
        MusicOption(displayName = "Run Maggot, Run!", musicId = 249),
        MusicOption(displayName = "Under a Clouded Moon", musicId = 250),
        MusicOption(displayName = "Autumn Footfalls", musicId = 251),
        MusicOption(displayName = "Flowers on the Battlefield", musicId = 252),
        MusicOption(displayName = "Echoes of a Zephyr", musicId = 253),
        MusicOption(displayName = "Griffons Never Die", musicId = 254),
    )

    override fun onInteraction(npcId: ActorId) {
        val availableOptions = options.filter { it.unlockCondition.invoke() }
            .map { QueryMenuOption(text = it.displayName, value = it.musicId) }
            .sortedBy { it.text }

        UiStateHelper.openQueryMode(prompt = "Which music?", options = availableOptions, callback = this::handleChoice)
    }

    private fun handleChoice(queryMenuOption: QueryMenuOption?): QueryMenuResponse {
        if (queryMenuOption == null || queryMenuOption.value < 0) { return QueryMenuResponse.popAll }
        GameV0SaveStateHelper.getState().baseCampMusic = queryMenuOption.value
        return QueryMenuResponse.popAll
    }

}

